Scriptname FNIS_PCEA2ConfigMenu extends SKI_ConfigBase  

FNIS_PCEA2QuestScript Property FNIS_PCEA2quest Auto

bool ONCE
int[] OId
int OIdRefresh
bool isRefreshed
bool isSelectionChanged

Event OnPageReset(string page)
	string[] SelectionName
	int i

	if Game.GetModByName("FNIS_PCEA2.esp") >= 255
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("FNIS_PCEA2.esp not activated")
		return
	endif
	if !FNIS_PCEA2quest.isStartOK
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("ERRORS when starting FNIS PCEA2")
		return
	endif
	
	If !ONCE
		OId = new int[10]
		ONCE = true
	endIf
Debug.Trace("FNIS PCEA2 Config RESET")
;Debug.Notification("FNIS PCEA2 Config RESET")
	
	i = 0
	while ( i < 10 )
		FNIS_PCEA2quest.isSelectedStart[i] = FNIS_PCEA2quest.isSelected[i]
		i += 1
	endWhile
	isRefreshed = false
	
    SetCursorFillMode(TOP_TO_BOTTOM)
	AddHeaderOption("Available Animation Collections")

	SelectionName = FNIS_PCEA2.GetSubDirList()
	i = 0
	while ( i < 10 )
		if ( StringUtil.GetNthChar(SelectionName[i],0) == "X" )
			i = 10
		else
			string name
			if ( StringUtil.GetNthChar(SelectionName[i],1) == "_" )
				name = StringUtil.Substring(SelectionName[i], 2)
			else
				name = StringUtil.Substring(SelectionName[i], 1)
			endif
			OId[i] = AddToggleOption(name, FNIS_PCEA2quest.isSelected[i])
			i += 1
		endif
	endWhile
	
	SetCursorPosition(1)
	OIdRefresh = AddToggleOption("Refresh PCEA2 animations NOW", isRefreshed)

endEvent

event OnOptionSelect(int option)
	If ( option == OIdRefresh)
		if !isRefreshed
			isRefreshed = true
			SetToggleOptionValue(OIdRefresh, isRefreshed)
		endif
		SendModEvent("PCEA2Task", "refresh")

	else
		int i = 0
		while ( i < 10 )
			If ( option == OId[i])
				FNIS_PCEA2quest.isSelected[i] = !FNIS_PCEA2quest.isSelected[i]
				SetToggleOptionValue(OId[i], FNIS_PCEA2quest.isSelected[i])
				isSelectionChanged = true
				i = 10
			endif
			i += 1
		endwhile
	endif
endEvent

Event OnConfigClose()
	Debug.Trace("FNIS PCEA2 Config close")
	int i
	if isSelectionChanged
		while i < 10
			if ( FNIS_PCEA2quest.isSelectedStart[i] != FNIS_PCEA2quest.isSelected[i] )
				SendModEvent("PCEA2Task", "set")
				i = 10
			endif
			i += 1
		endwhile
		isSelectionChanged = false
	endif
	isRefreshed = false
endEvent
